<?php

namespace App\Console\Commands;

use App\Enums\Role as RoleEnum;
use Illuminate\Console\Command;
use Spatie\Permission\Models\Role as SpatieRole;

class UpsertAuthorization extends Command
{
    protected $signature = 'upsert:authorization';

    protected $description = 'Upserts roles into the database';

    public function handle()
    {
        $this->info('Upserting roles...');

        foreach (RoleEnum::cases() as $role) {
            SpatieRole::findOrCreate($role->value, 'web');
        }

        $this->info('Roles upserted.');
    }
}
