<?php

namespace App\Filament\Pages;

use App\Support\MdMessagePage;
use Exception;
use Filament\Forms\Form;
use Filament\Forms;
use Filament\Pages\Page;
use Illuminate\Contracts\Support\Htmlable;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class MdMessage extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.md-message';

    public array $data = [];

    public static function getNavigationGroup(): ?string
    {
        return __('navigation.cms');
    }

    public function getTitle(): string|Htmlable
    {
        return __('md-message.md-message');
    }

    public static function getNavigationLabel(): string
    {
        return __('md-message.md-message');
    }

    public function mount(): void
    {
        $page = MdMessagePage::make();

        $this->form->fill([
            
            
            
            'message' => $page->message()->getRaw('message'),
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->statePath('data')
            ->schema([
                Forms\Components\Section::make(__('md-message.header'))
                    ->description(__('md-message.header-description'))
                    ->aside()
                    ->schema([
                        
                        Forms\Components\SpatieMediaLibraryFileUpload::make('cover')
                            ->label(__('md-message.cover-label'))
                            ->collection(MdMessagePage::MEDIA_COLLECTION_COVER)
                            ->model(MdMessagePage::make()->model())
                            ->required()
                        
                        ,
                    ]),
                Forms\Components\Section::make(__('md-message.message'))
                    ->description(__('md-message.message-description'))
                    ->aside()
                    ->schema([
                        
                        Forms\Components\SpatieMediaLibraryFileUpload::make('managing_director')
                            ->label(__('md-message.managing-director-label'))
                            ->collection(MdMessagePage::MEDIA_COLLECTION_MANAGING_DIRECTOR)
                            ->model(MdMessagePage::make()->model())
                            ->required()
                        
                        ,
                        
                        Forms\Components\RichEditor::make('message')
                            ->label(__('md-message.message-label'))
                            ->placeholder(__('md-message.message-placeholder'))
                            ->required()
                            ->translatable()
                        ,
                    ]),
            ]);
    }

    protected function getActions(): array
    {
        return [
            Action::make(__('app.update'))
                ->icon('heroicon-o-arrow-path')
                ->action(fn() => $this->publish()),
        ];
    }

    public function publish(): void
    {
        try {
            DB::beginTransaction();

            $page = MdMessagePage::make();
            $page->setCover(collect($this->data['cover'])->first());
            $page->setManagingDirector(collect($this->data['cover'])->first());
            $page->header()->patch([
                'cover' => $this->data['cover'],
            ]);
            $page->message()->patch([
                'managing-director' => $this->data['managing-director'],
                'message' => $this->data['message'],
            ]);

            Notification::make()
                ->success()
                ->title(__('app.content-update-success'))
                ->send();
            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            Log::error('Failed to update Md Message data', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            Notification::make()
                ->danger()
                ->title(__('app.content-update-failure'))
                ->send();
        }
    }
}
