<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ContactMessageResource\Pages;
use App\Models\ContactMessage;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class ContactMessageResource extends Resource
{
    protected static ?string $model = ContactMessage::class;

    protected static ?string $navigationIcon = 'heroicon-o-envelope';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make(__('contact-messages.details'))
                    ->description(__('contact-messages.details-description'))
                    ->aside()
                    ->schema([
                        Forms\Components\Select::make('user_id')
                            ->helperText(__('contact-messages.user-helper'))
                            ->label(__('contact-messages.user'))
                            ->relationship('user', 'name'),

                        Forms\Components\TextInput::make('name')
                            ->label(__('contact-messages.name'))
                            ->helperText(__('contact-messages.name-helper'))
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('email')
                            ->label(__('contact-messages.email'))
                            ->helperText(__('contact-messages.email-helper'))
                            ->email()
                            ->required()
                            ->maxLength(255),

                        Forms\Components\Textarea::make('message')
                            ->label(__('contact-messages.message'))
                            ->helperText(__('contact-messages.message-helper'))
                            ->required(),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('user.name')
                    ->label(__('contact-messages.user'))
                    ->badge(fn($state) => $state === __('contact-messages.guest'))
                    ->getStateUsing(fn($record) => $record->user?->name ?: __('contact-messages.guest'))
                    ->color(fn($state) => $state === __('contact-messages.guest') ? 'gray' : null)
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('name')
                    ->label(__('contact-messages.name'))
                    ->searchable(),

                Tables\Columns\TextColumn::make('email')
                    ->label(__('contact-messages.email'))
                    ->searchable(),

                Tables\Columns\TextColumn::make('message')
                    ->label(__('contact-messages.message'))
                    ->limit(50)
                    ->searchable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('contact-messages.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                Tables\Columns\TextColumn::make('updated_at')
                    ->label(__('contact-messages.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make()->slideOver(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListContactMessages::route('/'),
        ];
    }
}
