<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\LocalTalentResource;
use App\Models\LocalTalent;
use Illuminate\Http\JsonResponse;

class LocalTalentsController extends Controller
{
    public function index(): JsonResponse
    {
        $localTalents = LocalTalent::all();
        return response()->json(LocalTalentResource::collection($localTalents));
    }

    public function show(
        string $language,
        LocalTalent $localTalent
    ): JsonResponse {
        return response()->json(new LocalTalentResource($localTalent));
    }
}
