<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Collection;

abstract class BaseFormRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    protected function mapped(array $allowedAttributes = [], array $extraAttributes = []): array
    {
        $availabledAttributes = [];
        foreach ($allowedAttributes as $key => $value) {
            if ($this->has($key)) {
                $availabledAttributes[$value] = $this->input($key);
            }
        }

        $availabledAttributes = array_merge($availabledAttributes, $extraAttributes);

        return $availabledAttributes;
    }
}
