<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AboutUsPageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'about-us-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                ],
                'deepRoots' => [
                    'subtitle' => $this->deepRoots()->get('subtitle'),
                    'description' => $this->deepRoots()->get('description'),
                    'deepRootsImage' => $this->deepRootsImageUrl(),
                ],
                'qualityStandards' => [
                    'content' => $this->qualityStandards()->get('content'),
                ],
                'synergies' => [
                    'content' => $this->synergies()->get('content'),
                    'synergiesImage' => $this->synergiesImageUrl(),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
