<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ChairmanMessagePageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'chairman-message-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                ],
                'message' => [
                    'chairman' => $this->chairmanUrl(),
                    'message' => $this->message()->get('message'),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
