<?php

namespace App\Http\Resources;

use App\Models\Client;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClientResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "type" => "client",
            "id" => (string) $this->id,
            "attributes" => [
                "name" => $this->name, // Localized field
                "image" => $this->getFirstMediaUrl(
                    Client::MEDIA_COLLECTION_LOGO
                ),
                "createdAt" => $this->created_at,
                "updatedAt" => $this->updated_at,
            ],
            "links" => (object) [],
            "relationships" => (object) [],
        ];
    }
}
