<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClientsPageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "type" => "clients-page",
            "id" => $this->key(),
            "attributes" => [
                "header" => [
                    "title" => $this->header()->get("title"),
                    "description" => $this->header()->get("description"),
                    "cover" => $this->cover()?->getUrl(),
                ],
            ],
            "links" => (object) [],
            "relationships" => (object) [],
            "includes" => (object) [],
        ];
    }
}
