<?php

namespace App\Http\Resources;

use App\Models\LocalTalent;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LocalTalentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "type" => "local_talent",
            "id" => (string) $this->id,
            "attributes" => [
                "name" => $this->name,
                "description" => $this->description,
                "image" => $this->getFirstMediaUrl(
                    LocalTalent::MEDIA_COLLECTION_IMAGE
                ),
                "slug" => $this->slug,
                "createdAt" => $this->created_at,
                "updatedAt" => $this->updated_at,
            ],
            "links" => (object) [],
            "relationships" => (object) [],
        ];
    }
}
