<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MdMessagePageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'md-message-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                ],
                'message' => [
                    'managingDirector' => $this->managingDirectorUrl(),
                    'message' => $this->message()->get('message'),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
