<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OurCulturePageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'our-culture-page',
            'id' => $this->key(),
            'attributes' => [
                'header' =>
                    [ 'cover' => $this->coverUrl(), ],
                'values' =>
                    collect($this->values()->data())
                    ->flatMap(function ($group) {
                        return collect($group)->map(function ($value, $uuid) {
                            return [
                                "title" => $value["title"][app()->getLocale()],
                                "description" => $value["description"][app()->getLocale()],
                            ];
                        });
                    })
                    ->values()
                    ->all(),
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
            ],
        ];
    }
}
