<?php

namespace App\Http\Resources;

use App\Models\Partner;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PartnerResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "type" => "partner",
            "id" => (string) $this->id,
            "attributes" => [
                "name" => $this->name, // Localized field
                "image" => $this->getFirstMediaUrl(
                    Partner::MEDIA_COLLECTION_LOGO
                ),
                "createdAt" => $this->created_at,
                "updatedAt" => $this->updated_at,
            ],
            "links" => (object) [],
            "relationships" => (object) [],
        ];
    }
}
