<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PrivacyPolicyPageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "type" => "privacy-policy-page",
            "id" => $this->key(),
            "attributes" => [
                "cover" => $this->coverUrl(),
                "content" => $this->privacyPolicy()->get("content"),
            ],
            "links" => (object) [],
            "relationships" => (object) [],
            "includes" => (object) [],
        ];
    }
}
