<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TermsAndConditionsPageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'terms-and-conditions-page',
            'id' => $this->key(),
            'attributes' => [
                'termsAndConditions' => [
                    'cover' => $this->coverUrl(),
                    'content' => $this->termsAndConditions()->get('content'),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
