<?php

namespace App\Support;

class PrivacyPolicyPage extends Page
{
    public function key(): string
    {
        return 'privacy-policy';
    }
    
    public function privacyPolicy(): Section
    {
        return $this->get('privacy-policy', [
            'content' => [
                'en' => 'lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna aliqua',
                'ar' => 'لوريم إيبسوم هو نموذج نصي يوضع في التصميم وتصاميم وتطبيقات الويب (وهو مثال يوضع في الصميم لتعرضه إلى المطور.',
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "privacy-policy.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Privacy Policy');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
