<?php

namespace App\Support;

class SolutionsOverviewPage extends Page
{
    public function key(): string
    {
        return 'solutions-overview';
    }
    
    public function header(): Section
    {
        return $this->get('header', [
            'cover' => [
                'en' => '',
                'ar' => '',
            ],
            'title' => [
                'en' => 'Industry Leading Facility Management Services',
                'ar' => 'خدمات إدارة المرافق الرائدة في الصناعة',
            ],
            'description' => [
                'en' => 'A wide range of specialized and integrated FM services customized to meet all your facility management needs to maintain conducive, optimized, and productive environment.',
                'ar' => 'مجموعة واسعة من خدمات إدارة المرافق المتخصصة والمتكاملة المصممة لتلبية جميع احتياجاتك في إدارة المرافق للحفاظ على بيئة مواتية ومحسنة ومنتجة.',
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "solutions-overview.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Solutions Overview');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
