<?php

namespace App\Support;

class TermsAndConditionsPage extends Page
{
    public function key(): string
    {
        return 'terms-and-conditions';
    }
    
    public function termsAndConditions(): Section
    {
        return $this->get('terms-and-conditions', [
            'cover' => [
                'en' => '',
                'ar' => '',
            ],
            'content' => [
                'en' => 'lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna aliqua',
                'ar' => 'لوريم إيبسوم هو نموذج نصي يوضع في التصميم وتصاميم وتطبيقات الويب (وهو مثال يوضع في الصميم لتعرضه إلى المطور.',
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "terms-and-conditions.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Terms And Conditions');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
