<?php

namespace Database\Factories;

use App\Models\Project;

class ProjectFactory extends BaseFactory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Project::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition(): array
    {
        return [
            "title" => $this->localized(fn(): string => $this->faker->sentence(3)),
            "subtitle" => $this->localized(fn(): string => $this->faker->sentence(5)),
            "number_of_staff" => $this->faker->optional(false, 0)->numberBetween(1, 50),
            "number_of_locations" => $this->faker->optional(false, 0)->numberBetween(1, 10),
            "starting_year" => $this->faker->optional(false, date('Y'))->year(),
            "contract_duration" => $this->faker
                ->optional(false, "1 year")
                ->randomElement([
                    "3 months",
                    "6 months",
                    "1 year",
                    "2 years",
                    "3 years",
                ]),
        ];
    }
}
