<?php

namespace Tests\Feature\Filament\Pages;

use App\Filament\Pages\Socials;
use App\Models\SocialLink;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Livewire\Livewire;
use Tests\TestCase;
use Tests\Traits\WithAdmin;

class SocialsTest extends TestCase
{
    use RefreshDatabase, WithAdmin;

    public function test_socials_page_can_be_rendered()
    {
        $this->get(route('filament.admin.pages.socials'))
            ->assertOk();
    }

    public function test_it_updates_store_links()
    {
        $platforms = ['whatsapp', 'facebook', 'instagram', 'tiktok'];
        foreach ($platforms as $platform) {
            SocialLink::factory()->create([
                'platform' => $platform,
            ]);
        }

        Livewire::test(Socials::class)
            ->fillForm([
                'socials' => [
                    'whatsapp' => 'https://whatsapp.app',
                    'facebook' => 'https://facebook.app',
                    'instagram' => 'https://instagram.app',
                    'tiktok' => 'https://tiktok.app',
                ],
            ])
            ->call('save')
            ->assertHasNoFormErrors();

        $this->assertDatabaseCount('social_links', count($platforms));
        foreach ($platforms as $platform) {
            $this->assertDatabaseHas('social_links', ['platform' => $platform, 'link' => 'https://' . $platform . '.app']);
        }
    }
}
