<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Http\Resources\LocalTalentResource;
use App\Models\LocalTalent;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Str;
use Tests\TestCase;

class LocalTalentsControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_returns_local_talents(): void
    {
        $localTalents = LocalTalent::factory()->count(3)->create();
        $resource = LocalTalentResource::collection($localTalents);

        $this->get(route("api.local-talents.index", ["lang" => "en"]))
            ->assertOk()
            ->assertJson($resource->response()->getData(true));
    }

    public function test_it_fetches_local_talent_by_slug(): void
    {
        $localTalent = LocalTalent::factory()->create([
            "name" => "John Doe",
            "slug" => Str::slug("John Doe"),
        ]);

        $this->get(
            route("api.local-talents.show", ["slug" => $localTalent->slug])
        )
            ->assertOk()
            ->assertJson([
                "data" => [
                    "type" => "local_talent",
                    "id" => (string) $localTalent->id,
                    "attributes" => [
                        "name" => $localTalent->name,
                        "description" => $localTalent->description,
                        "image" => $localTalent->getFirstMediaUrl("images"),
                        "createdAt" => $localTalent->created_at->toISOString(),
                        "updatedAt" => $localTalent->updated_at->toISOString(),
                    ],
                ],
            ]);
    }
}
