<?php

namespace Tests\Feature\Filament\Pages;

use App\Filament\Pages\PrivacyPolicy;
use App\Support\PrivacyPolicyPage;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\Response;
use Livewire\Livewire;
use Tests\TestCase;
use Tests\Traits\WithAdmin;

//  TODO: Might wanna move this to filament tests (maybe)

class PrivacyPolicyPageTest extends TestCase
{
    use RefreshDatabase, WithAdmin;

    public function setUp(): void
    {
        parent::setUp();

        PrivacyPolicyPage::make()->body()->patch([
            'content' => ['en' => 'privacy content'],
            'description' => ['en' => 'privacy description'],
        ]);
    }

    public function test_it_renders_the_pagea(): void
    {
        $this->get(route('filament.admin.pages.privacy-policy'))
            ->assertStatus(Response::HTTP_OK);
    }

    public function test_it_contains_privacy_policy_details(): void
    {
        $livewire = Livewire::test(PrivacyPolicy::class);
        $livewire->assertSet('data.content.en', 'privacy content');
    }

    public function test_it_updates_privacy_policy_page_details(): void
    {
        $livewire = Livewire::test(PrivacyPolicy::class);
        $livewire->set('data.content', 'Updated privacy content');
        $livewire->call('publish');

        $this->assertEquals('Updated privacy content', PrivacyPolicyPage::make()->body()->get('content'));
    }

    public function test_it_resets_to_default_value_when_passing_an_empty_string_as_the_value(): void
    {
        $livewire = Livewire::test(PrivacyPolicy::class);
        $livewire->set('data.content', '');
        $livewire->call('publish');

        dd(PrivacyPolicyPage::make()->body()['content']['en']);
        $this->assertEquals('Privacy content', PrivacyPolicyPage::make()->body()['content']['en']);
    }
}
