<?php

namespace App\Filament\Pages;

use App\Support\AboutUsPage;
use Exception;
use Filament\Forms\Form;
use Filament\Forms;
use Filament\Pages\Page;
use Illuminate\Contracts\Support\Htmlable;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class AboutUs extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.about-us';

    public array $data = [];

    public static function getNavigationGroup(): ?string
    {
        return __('navigation.cms');
    }

    public function getTitle(): string|Htmlable
    {
        return __('about-us.about-us');
    }

    public static function getNavigationLabel(): string
    {
        return __('about-us.about-us');
    }

    public function mount(): void
    {
        $page = AboutUsPage::make();

        $this->form->fill([
            
            
            'subtitle' => $page->deepRoots()->getRaw('subtitle'),
            
            'description' => $page->deepRoots()->getRaw('description'),
            
            
            'content' => $page->qualityStandards()->getRaw('content'),
            
            'content' => $page->synergies()->getRaw('content'),
            
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->statePath('data')
            ->schema([
                Forms\Components\Section::make(__('about-us.header'))
                    ->description(__('about-us.header-description'))
                    ->aside()
                    ->schema([
                        
                        Forms\Components\SpatieMediaLibraryFileUpload::make('cover')
                            ->label(__('about-us.cover-label'))
                            ->collection(AboutUsPage::MEDIA_COLLECTION_COVER)
                            ->model(AboutUsPage::make()->model())
                            ->required()
                        
                        ,
                    ]),
                Forms\Components\Section::make(__('about-us.deep-roots'))
                    ->description(__('about-us.deep-roots-description'))
                    ->aside()
                    ->schema([
                        
                        Forms\Components\TextInput::make('subtitle')
                            ->label(__('about-us.subtitle-label'))
                            ->placeholder(__('about-us.subtitle-placeholder'))
                            ->required()
                            ->maxLength(255)
                            ->translatable()
                        ,
                        
                        Forms\Components\RichEditor::make('description')
                            ->label(__('about-us.description-label'))
                            ->placeholder(__('about-us.description-placeholder'))
                            ->required()
                            ->translatable()
                        ,
                        
                        Forms\Components\SpatieMediaLibraryFileUpload::make('deep_roots_image')
                            ->label(__('about-us.deep-roots-image-label'))
                            ->collection(AboutUsPage::MEDIA_COLLECTION_DEEP_ROOTS_IMAGE)
                            ->model(AboutUsPage::make()->model())
                            ->required()
                        
                        ,
                    ]),
                Forms\Components\Section::make(__('about-us.quality-standards'))
                    ->description(__('about-us.quality-standards-description'))
                    ->aside()
                    ->schema([
                        
                        Forms\Components\RichEditor::make('content')
                            ->label(__('about-us.content-label'))
                            ->placeholder(__('about-us.content-placeholder'))
                            ->required()
                            ->translatable()
                        ,
                    ]),
                Forms\Components\Section::make(__('about-us.synergies'))
                    ->description(__('about-us.synergies-description'))
                    ->aside()
                    ->schema([
                        
                        Forms\Components\RichEditor::make('content')
                            ->label(__('about-us.content-label'))
                            ->placeholder(__('about-us.content-placeholder'))
                            ->required()
                            ->translatable()
                        ,
                        
                        Forms\Components\SpatieMediaLibraryFileUpload::make('synergies_image')
                            ->label(__('about-us.synergies-image-label'))
                            ->collection(AboutUsPage::MEDIA_COLLECTION_SYNERGIES_IMAGE)
                            ->model(AboutUsPage::make()->model())
                            ->required()
                        
                        ,
                    ]),
            ]);
    }

    protected function getActions(): array
    {
        return [
            Action::make(__('app.update'))
                ->icon('heroicon-o-arrow-path')
                ->action(fn() => $this->publish()),
        ];
    }

    public function publish(): void
    {
        try {
            DB::beginTransaction();

            $page = AboutUsPage::make();
            $page->setCover(collect($this->data['cover'])->first());
            $page->setDeepRootsImage(collect($this->data['cover'])->first());
            $page->setSynergiesImage(collect($this->data['cover'])->first());
            $page->header()->patch([
                'cover' => $this->data['cover'],
            ]);
            $page->deepRoots()->patch([
                'subtitle' => $this->data['subtitle'],
                'description' => $this->data['description'],
                'deep-roots-image' => $this->data['deep-roots-image'],
            ]);
            $page->qualityStandards()->patch([
                'content' => $this->data['content'],
            ]);
            $page->synergies()->patch([
                'content' => $this->data['content'],
                'synergies-image' => $this->data['synergies-image'],
            ]);

            Notification::make()
                ->success()
                ->title(__('app.content-update-success'))
                ->send();
            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            Log::error('Failed to update About Us data', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            Notification::make()
                ->danger()
                ->title(__('app.content-update-failure'))
                ->send();
        }
    }
}
