<?php

namespace App\Filament\Pages;

use App\Support\OurCulturePage;
use Exception;
use Filament\Forms\Form;
use Filament\Forms;
use Filament\Pages\Page;
use Illuminate\Contracts\Support\Htmlable;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class OurCulture extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.our-culture';

    public array $data = [];

    public static function getNavigationGroup(): ?string
    {
        return __('navigation.cms');
    }

    public function getTitle(): string|Htmlable
    {
        return __('our-culture.our-culture');
    }

    public static function getNavigationLabel(): string
    {
        return __('our-culture.our-culture');
    }

    public function mount(): void
    {
        $page = OurCulturePage::make();

        $this->form->fill([
            
            
            'values' => $page->values()->data(),
            
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->statePath('data')
            ->schema([
                Forms\Components\Section::make(__('our-culture.header'))
                    ->description(__('our-culture.header-description'))
                    ->aside()
                    ->schema([
                        
                        Forms\Components\SpatieMediaLibraryFileUpload::make('cover')
                            ->label(__('our-culture.cover-label'))
                            ->collection(OurCulturePage::MEDIA_COLLECTION_COVER)
                            ->model(OurCulturePage::make()->model())
                            ->required()
                        
                        ,
                    ]),
                Forms\Components\Section::make(__('our-culture.values'))
                    ->description(__('our-culture.values-description'))
                    ->aside()
                    ->schema([
                        
                          Forms\Components\Repeater::make('values')
                            ->required()
                            ->schema([
                                
                                Forms\Components\TextInput::make('title')
                                    ->label(__('our-culture.title-label'))
                                    ->placeholder(__('our-culture.title-placeholder'))
                                    ->required()
                                    ->maxLength(100)
                                    ->translatable()
                                ,
                                
                                Forms\Components\RichEditor::make('description')
                                    ->label(__('our-culture.description-label'))
                                    ->placeholder(__('our-culture.description-placeholder'))
                                    ->required()
                                    ->translatable()
                                ,
                            ])
                        ,
                    ]),
            ]);
    }

    protected function getActions(): array
    {
        return [
            Action::make(__('app.update'))
                ->icon('heroicon-o-arrow-path')
                ->action(fn() => $this->publish()),
        ];
    }

    public function publish(): void
    {
        try {
            DB::beginTransaction();

            $page = OurCulturePage::make();
                    
            $page->setCover(collect($this->data['cover'])->first());
                    
            $page->header()->patch([
            ]);
            $page->values()->patch([
                'values' => array_values($this->data['values']),
            ]);

            Notification::make()
                ->success()
                ->title(__('app.content-update-success'))
                ->send();
            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            Log::error('Failed to update Our Culture data', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            Notification::make()
                ->danger()
                ->title(__('app.content-update-failure'))
                ->send();
        }
    }
}
