<?php

namespace App\Filament\Pages;

use App\Support\PrivacyPolicyPage;
use Exception;
use Filament\Forms\Form;
use Filament\Forms;
use Filament\Pages\Page;
use Illuminate\Contracts\Support\Htmlable;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class PrivacyPolicy extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.privacy-policy';

    public array $data = [];

    public static function getNavigationGroup(): ?string
    {
        return __('navigation.cms');
    }

    public function getTitle(): string|Htmlable
    {
        return __('privacy-policy.privacy-policy');
    }

    public static function getNavigationLabel(): string
    {
        return __('privacy-policy.privacy-policy');
    }

    public function mount(): void
    {
        $page = PrivacyPolicyPage::make();

        $this->form->fill([
            
            
            'content' => $page->privacyPolicy()->getRaw('content'),
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->statePath('data')
            ->schema([
                Forms\Components\Section::make(__('privacy-policy.privacy-policy'))
                    ->description(__('privacy-policy.privacy-policy-description'))
                    ->aside()
                    ->schema([
                        
                        Forms\Components\SpatieMediaLibraryFileUpload::make('cover')
                            ->label(__('privacy-policy.cover-label'))
                            ->collection(PrivacyPolicyPage::MEDIA_COLLECTION_COVER)
                            ->model(PrivacyPolicyPage::make()->model())
                            ->required()
                        
                        ,
                        
                        Forms\Components\RichEditor::make('content')
                            ->label(__('privacy-policy.content-label'))
                            ->placeholder(__('privacy-policy.content-placeholder'))
                            ->required()
                            ->translatable()
                        ,
                    ]),
            ]);
    }

    protected function getActions(): array
    {
        return [
            Action::make(__('app.update'))
                ->icon('heroicon-o-arrow-path')
                ->action(fn() => $this->publish()),
        ];
    }

    public function publish(): void
    {
        try {
            DB::beginTransaction();

            $page = PrivacyPolicyPage::make();
                    
            $page->setCover(collect($this->data['cover'])->first());
                    
            $page->privacyPolicy()->patch([
                'content' => $this->data['content'],
            ]);

            Notification::make()
                ->success()
                ->title(__('app.content-update-success'))
                ->send();
            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            Log::error('Failed to update Privacy Policy data', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            Notification::make()
                ->danger()
                ->title(__('app.content-update-failure'))
                ->send();
        }
    }
}
