<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CustomerResource\Pages;
use App\Models\Customer;
use Carbon\Carbon;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class CustomerResource extends Resource
{
    protected static ?string $model = Customer::class;

    protected static ?string $navigationIcon = 'heroicon-o-user-circle';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make(__('customers.details'))
                    ->description(__('customers.details-description'))
                    ->aside()
                    ->schema([
                        Forms\Components\Group::make()
                            ->relationship('user')
                            ->schema([
                                Forms\Components\TextInput::make('name')
                                    ->label(__('customers.name'))
                                    ->helperText(__('customers.name-helper'))
                                    ->disabled()
                                    ->required(),

                                Forms\Components\TextInput::make('email')
                                    ->label(__('customers.email'))
                                    ->helperText(__('customers.email-helper'))
                                    ->disabled()
                                    ->required(),
                            ]),

                        Forms\Components\TextInput::make('created_at')
                            ->label(__('customers.created_at'))
                            ->formatStateUsing(fn($state) => Carbon::parse($state)->format('Y-m-d H:i:s'))
                            ->disabled()
                            ->required(),

                        Forms\Components\TextInput::make('updated_at')
                            ->label(__('customers.updated_at'))
                            ->formatStateUsing(fn($state) => Carbon::parse($state)->format('Y-m-d H:i:s'))
                            ->disabled()
                            ->required(),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('user.name')
                    ->label(__('customers.user'))
                    ->sortable()
                    ->searchable(),

                // cTables\Columns\TextColumn::make('avatar')
                // c    ->searchable(),

                Tables\Columns\TextColumn::make('user.email')
                    ->label(__('customers.email'))
                    ->searchable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('customers.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                Tables\Columns\TextColumn::make('updated_at')
                    ->label(__('customers.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make()->modal(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCustomers::route('/'),
        ];
    }
}
