<?php

namespace App\Http\Controllers\Api;

use App\Contracts\ResponseBuilder;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;

class AuthTokenExchangeController extends Controller
{
    public function __construct(protected ResponseBuilder $response)
    {
        //
    }

    public function exchange()
    {
        $sessionKey = request('sessionKey');
        $accessToken = Cache::pull('session_keys_' . $sessionKey);

        if (!$accessToken) {
            return response()->json(['error' => 'Invalid session key'], 400);
        }

        return response()->json(['access_token' => $accessToken]);
    }
}
