<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\NewsResource;
use App\Models\News;
use Illuminate\Http\JsonResponse;

class NewsController extends Controller
{
    public function index(): JsonResponse
    {
        $news = News::all();
        return response()->json(NewsResource::collection($news));
    }

    public function show(string $language, News $news): JsonResponse
    {
        return response()->json(new NewsResource($news));
    }
}
