<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\ProjectResource;
use App\Models\Project;
use Illuminate\Http\JsonResponse;

class ProjectsController extends Controller
{
    public function index(): JsonResponse
    {
        $projects = Project::all();
        return response()->json(ProjectResource::collection($projects));
    }

    public function show(string $language, Project $project): JsonResponse
    {
        return response()->json(new ProjectResource($project));
    }
}
