<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;

class StoreContactMessageRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'data.attributes.name' => 'required|string',
            'data.attributes.email' => 'required|email',
            'data.attributes.message' => 'required|string',
        ];
    }

    public function mappedAttributes(): array
    {
        return $this->mapped([
            'data.attributes.name' => 'name',
            'data.attributes.email' => 'email',
            'data.attributes.message' => 'message',
        ], ['user_id' => Auth::user()?->id]);
    }
}
