<?php

namespace App\Http\Resources;

use App\Models\News;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class NewsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "type" => "news",
            "id" => (string) $this->id,
            "attributes" => [
                "title" => $this->title, // Localized field
                "body" => $this->body, // Localized rich text
                "slug" => $this->slug,
                "image" => $this->getFirstMediaUrl(
                    News::MEDIA_COLLECTION_COVER
                ), // Media Library image
                "createdAt" => $this->created_at,
                "updatedAt" => $this->updated_at,
            ],
            "links" => (object) [],
            "relationships" => (object) [],
        ];
    }
}
