<?php

namespace App\Http\Resources;

use App\Models\Project;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "type" => "project",
            "id" => (string) $this->id,
            "attributes" => [
                "title" => $this->title,
                "subtitle" => $this->subtitle,
                "slug" => $this->slug,
                "logo" => $this->getFirstMediaUrl(
                    Project::MEDIA_COLLECTION_LOGO
                ),
                "image" => $this->getFirstMediaUrl(
                    Project::MEDIA_COLLECTION_IMAGE
                ),
                "numberOfStaff" => $this->number_of_staff,
                "numberOfLocations" => $this->number_of_locations,
                "startingYear" => $this->starting_year,
                "contractDuration" => $this->contract_duration,
                "createdAt" => $this->created_at,
                "updatedAt" => $this->updated_at,
            ],
            "links" => (object) [],
            "relationships" => (object) [],
        ];
    }
}
