<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SolutionsOverviewPageResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => 'solutions-overview-page',
            'id' => $this->key(),
            'attributes' => [
                'header' => [
                    'cover' => $this->coverUrl(),
                    'title' => $this->header()->get('title'),
                    'description' => $this->header()->get('description'),
                ],
            ],
            'links' => (object) [],
            'relationships' => (object) [],
            'includes' => (object) [],
        ];
    }
}
