<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\Translatable\HasTranslations;

class Client extends Model implements HasMedia
{
    use HasFactory, HasTranslations, InteractsWithMedia;

    protected $fillable = ["name"];

    public $translatable = ["name"];
    public const MEDIA_COLLECTION_LOGO = "logo";

    public function registerMediaCollections(): void
    {
        $fallback =
            "https://placehold.co/400x225.png?text=" .
            str_replace(" ", "%20", $this->name);

        $this->addMediaCollection(self::MEDIA_COLLECTION_LOGO)->useFallbackUrl(
            $fallback
        );
    }
}
