<?php

namespace App\Support;

class AboutUsPage extends Page
{
    public function key(): string
    {
        return 'about-us';
    }
    
    public function header(): Section
    {
        return $this->get('header', [
            'cover' => [
                'en' => '',
                'ar' => '',
            ],
        ]);
    }
    
    public function deepRoots(): Section
    {
        return $this->get('deep-roots', [
            'subtitle' => [
                'en' => 'Integrated facility management services to transform facilities and workspaces into healthy, vibrant living.',
                'ar' => 'خدمات إدارة مرافق متكاملة لتحويل المنشآت ومساحات العمل إلى بيئة صحية وحيوية.',
            ],
            'description' => [
                'en' => 'Founded in 2010, the Business Hospitality Facilities Management Company (MFM) is a leading facilities services company in Saudi Arabia. A 100% Saudi‑owned subsidiary of Alturki Holding headquartered in Al Khobar, Business Hospitality extends a full range of facilities management services and solutions, tailored to meet the diverse needs of clients – from master developments to residential communities, industrial sites, and commercial offices.',
                'ar' => 'تأسست شركة إدارة مرافق الضيافة للأعمال (MFM) في عام 2010، وهي شركة رائدة في خدمات المرافق في المملكة العربية السعودية. وتعد شركة مملوكة بنسبة 100٪ لشركة التركي القابضة، ويقع مقرها الرئيسي في الخبر. تقدم شركة الضيافة للأعمال مجموعة كاملة من خدمات وحلول إدارة المرافق المصممة لتلبية الاحتياجات المتنوعة للعملاء – بدءًا من المشاريع الكبرى إلى المجتمعات السكنية، والمواقع الصناعية، والمكاتب التجارية.',
            ],
            'deep-roots-image' => [
                'en' => '',
                'ar' => '',
            ],
        ]);
    }
    
    public function qualityStandards(): Section
    {
        return $this->get('quality-standards', [
            'content' => [
                'en' => 'Business Hospitality manages and maintains its client facilities to the highest standards in terms of quality, efficiency, and cost-control, in accordance with the global best practices and Quality, Health, Safety and Environment (QHSE) requirements.',
                'ar' => 'تدير شركة الضيافة للأعمال مرافق عملائها وتحافظ عليها وفقًا لأعلى المعايير من حيث الجودة والكفاءة والتحكم في التكاليف، وذلك وفقًا لأفضل الممارسات العالمية ومتطلبات الجودة والصحة والسلامة والبيئة (QHSE).',
            ],
        ]);
    }
    
    public function synergies(): Section
    {
        return $this->get('synergies', [
            'content' => [
                'en' => 'At MFM, we believe in creating synergies to create maximum value for our clients. Our partners and service-providers have been our strength throughout our journey. They continue to contribute to our progress in various ways, helping us deliver to the best of our capabilities and continually exceeding our clients’ expectations. Since our inception 12 years ago, we have succeeded in placing Business Hospitality as one of the industry leaders with annual revenue of SAR 100+M, and contract backlog of around SAR177Million, with contracts ranging from 1 to 5years. Our high client retention rate (98%) is both a proof and an outcome of our commitment to excellence in our services.',
                'ar' => 'في شركة MFM، نؤمن بخلق التآزر لتحقيق أقصى قيمة لعملائنا. لقد كان شركاؤنا ومقدمو الخدمات مصدر قوتنا طوال مسيرتنا، ولا يزالون يساهمون في تقدمنا بطرق متعددة، مما يساعدنا على تقديم أفضل ما لدينا وتجاوز توقعات عملائنا باستمرار. منذ تأسيسنا قبل 12 عامًا، نجحنا في وضع شركة الضيافة للأعمال كواحدة من الشركات الرائدة في القطاع، بإيرادات سنوية تتجاوز 100 مليون ريال سعودي، وتراكم تعاقدي يقارب 177 مليون ريال سعودي، مع عقود تتراوح مدتها بين سنة وخمس سنوات. إن معدل الاحتفاظ المرتفع بعملائنا (98٪) هو دليل ونتيجة لالتزامنا بالتميّز في خدماتنا.',
            ],
            'synergies-image' => [
                'en' => '',
                'ar' => '',
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "about-us.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'About Us');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
    const MEDIA_COLLECTION_DEEP_ROOTS_IMAGE = "about-us.deep-roots-image";

    public function deepRootsImage()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_DEEP_ROOTS_IMAGE);
    }

    public function deepRootsImageUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_DEEP_ROOTS_IMAGE);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'About Us');
        return $fallback;
    }

    public function setDeepRootsImage($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_DEEP_ROOTS_IMAGE);
    }
    const MEDIA_COLLECTION_SYNERGIES_IMAGE = "about-us.synergies-image";

    public function synergiesImage()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_SYNERGIES_IMAGE);
    }

    public function synergiesImageUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_SYNERGIES_IMAGE);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'About Us');
        return $fallback;
    }

    public function setSynergiesImage($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_SYNERGIES_IMAGE);
    }
}
