<?php

namespace App\Support;

class ChairmanMessagePage extends Page
{
    public function key(): string
    {
        return 'chairman-message';
    }
    
    public function header(): Section
    {
        return $this->get('header', [
            'cover' => [
                'en' => '',
                'ar' => '',
            ],
        ]);
    }
    
    public function message(): Section
    {
        return $this->get('message', [
            'chairman' => [
                'en' => '',
                'ar' => '',
            ],
            'message' => [
                'en' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
                'ar' => 'هذا نص تجريبي يُستخدم كعنصر نائب لاختبار عرض المحتوى. يمكن تعديل هذا النص لاحقًا ليعكس رسالة الرئيس الحقيقية.',
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "chairman-message.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Chairman Message');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
    const MEDIA_COLLECTION_CHAIRMAN = "chairman-message.chairman";

    public function chairman()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_CHAIRMAN);
    }

    public function chairmanUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_CHAIRMAN);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Chairman Message');
        return $fallback;
    }

    public function setChairman($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_CHAIRMAN);
    }
}
