<?php

namespace App\Support;

class ClientsPage extends Page
{
    public function key(): string
    {
        return "clients";
    }

    public function header(): Section
    {
        return $this->get("header", [
            "title" => [
                "en" => "Our Clients",
                "ar" => "عملائنا",
            ],
            "description" => [
                "en" =>
                    "We build long-lasting relationships with our clients, based on trust and commitment. Featuring some of the most prestigious regional as well as international brands, it is our distinguished clientele that inspires us to constantly deliver better.",
                "ar" =>
                    "نحن نبني علاقات طويلة الأمد مع عملائنا، قائمة على الثقة والالتزام. ومن خلال تعاوننا مع بعض من أبرز العلامات التجارية الإقليمية والدولية، فإن عملاءنا المتميزين هم مصدر إلهامنا لتقديم الأفضل باستمرار.",
            ],
        ]);
    }

    const MEDIA_COLLECTION_COVER = "clients.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function setCover($cover)
    {
        $this->model()
            ->addMedia($cover)
            ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
