<?php

namespace App\Support;

class MajorProjectsPage extends Page
{
    public function key(): string
    {
        return 'major-projects';
    }
    
    public function header(): Section
    {
        return $this->get('header', [
            'cover' => [
                'en' => '',
                'ar' => '',
            ],
            'title' => [
                'en' => 'Unwavering Commitment to Quality',
                'ar' => 'التزام لا يتزعزع بالجودة',
            ],
            'description' => [
                'en' => 'Leading sustainable FM solutions & services across a wide range of industry sectors to address immediate and future facility challenges of our diverse and ever‑increasing clientele, featuring some of the most prestigious global and local brands.',
                'ar' => 'قيادة حلول وخدمات إدارة المرافق المستدامة عبر مجموعة واسعة من القطاعات الصناعية لمعالجة التحديات الفورية والمستقبلية لمنشآت عملائنا المتنوعين والمتزايدين باستمرار، مع عرض بعض أرقى العلامات التجارية العالمية والمحلية.',
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "major-projects.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Major Projects');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
