<?php

namespace App\Support;

class MdMessagePage extends Page
{
    public function key(): string
    {
        return 'md-message';
    }
    
    public function header(): Section
    {
        return $this->get('header', [
            'cover' => [
                'en' => '',
                'ar' => '',
            ],
        ]);
    }
    
    public function message(): Section
    {
        return $this->get('message', [
            'managing-director' => [
                'en' => '',
                'ar' => '',
            ],
            'message' => [
                'en' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
                'ar' => 'هذا نص تجريبي يُستخدم كعنصر نائب لاختبار عرض المحتوى. يمكن تعديل هذا النص لاحقًا ليتناسب مع رسالة المدير العام الحقيقية.',
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "md-message.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Md Message');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
    const MEDIA_COLLECTION_MANAGING_DIRECTOR = "md-message.managing-director";

    public function managingDirector()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_MANAGING_DIRECTOR);
    }

    public function managingDirectorUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_MANAGING_DIRECTOR);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Md Message');
        return $fallback;
    }

    public function setManagingDirector($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_MANAGING_DIRECTOR);
    }
}
