<?php

namespace App\Support;

class NewsPage extends Page
{
    public function key(): string
    {
        return 'news';
    }
    
    public function header(): Section
    {
        return $this->get('header', [
            'cover' => [
                'en' => '',
                'ar' => '',
            ],
            'title' => [
                'en' => 'News',
                'ar' => 'الأخبار',
            ],
            'description' => [
                'en' => 'Review our most important news and achievements at the national level.',
                'ar' => 'راجع أهم أخبارنا وإنجازاتنا على المستوى الوطني.',
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "news.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'News');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
