<?php

namespace App\Support;

class OurCulturePage extends Page
{
    public function key(): string
    {
        return 'our-culture';
    }
    
    public function header(): Section
    {
        return $this->get('header', [
        ]);
    }
    
    public function values(): Section
    {
        return $this->get('values', [
            [
                'description' => [
                    'en' => 'We are driven by unrelenting passion to lead the industry by delivering value and results.',
                    'ar' => 'ندفعه شغف لا يلين لقيادة الصناعة من خلال تقديم القيمة والنتائج.',
                ],
                'title' => [
                    'en' => 'Passion',
                    'ar' => 'الشغف',
                ],
            ],
            [
                'description' => [
                    'en' => 'We place excellence at the heart of everything we do to exceed our clients’ expectations with unmatched service and quality.',
                    'ar' => 'نضع التميز في صميم كل ما نقوم به لتجاوز توقعات عملائنا بخدمات وجودة لا مثيل لها.',
                ],
                'title' => [
                    'en' => 'Excellence',
                    'ar' => 'التميز',
                ],
            ],
            [
                'description' => [
                    'en' => 'We respect all our stakeholders, partners, clients, and our environment.',
                    'ar' => 'نحترم جميع أصحاب المصلحة والشركاء والعملاء وبيئتنا.',
                ],
                'title' => [
                    'en' => 'Respect',
                    'ar' => 'الاحترام',
                ],
            ],
            [
                'description' => [
                    'en' => 'We believe in bringing fun into our corporate environment, recognize efforts and celebrate achievements.',
                    'ar' => 'نؤمن بجلب المرح إلى بيئتنا المؤسسية، والاعتراف بالجهود والاحتفال بالإنجازات.',
                ],
                'title' => [
                    'en' => 'Fun',
                    'ar' => 'المرح',
                ],
            ],
            [
                'description' => [
                    'en' => 'We are open to ideas and diversity as we believe that transparency is the key to progress and positivity.',
                    'ar' => 'نحن منفتحون على الأفكار والتنوع لأننا نعتقد أن الشفافية هي مفتاح التقدم والإيجابية.',
                ],
                'title' => [
                    'en' => 'Openness',
                    'ar' => 'الانفتاح',
                ],
            ],
            [
                'description' => [
                    'en' => 'We are fully committed and dedicated to deliver consistent services and meet the diverse needs of our clients.',
                    'ar' => 'نحن ملتزمون تمامًا ومكرسون لتقديم خدمات متسقة وتلبية الاحتياجات المتنوعة لعملائنا.',
                ],
                'title' => [
                    'en' => 'Reliability',
                    'ar' => 'الموثوقية',
                ],
            ],
            [
                'description' => [
                    'en' => 'We engage in activities that provide value to the society and the environment at large.',
                    'ar' => 'نشارك في أنشطة توفر قيمة للمجتمع والبيئة بشكل عام.',
                ],
                'title' => [
                    'en' => 'Meaning',
                    'ar' => 'المعنى',
                ],
            ],
        ]);
    }
    
    const MEDIA_COLLECTION_COVER = "our-culture.cover";

    public function cover()
    {
        return $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
    }

    public function coverUrl(): string
    {
        $media = $this->model()->getFirstMedia(self::MEDIA_COLLECTION_COVER);
        if ($media) {
            return $media->getUrl();
        }

        $fallback = 'https://placehold.co/400x225.png?text=' . str_replace(' ', '%20', 'Our Culture');
        return $fallback;
    }

    public function setCover($file)
    {
        $this->model()
             ->addMedia($file)
             ->toMediaCollection(self::MEDIA_COLLECTION_COVER);
    }
}
