<?php

namespace Database\Factories;

use App\Models\LocalTalent;

class LocalTalentFactory extends BaseFactory
{
    protected $model = LocalTalent::class;

    public function definition(): array
    {
        return [
            "name" => $this->localized(fn(): string => $this->faker->name),
            "description" => $this->localized(
                fn(): string => $this->faker->paragraphs(3, true)
            ),
            "slug" => $this->faker->unique()->slug,
        ];
    }
}
