<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create("local_talents", function (Blueprint $table) {
            $table->id();
            $table->string("name");
            $table->json("description"); // Localized rich text
            $table->string("slug")->unique();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists("local_talents");
    }
};
