<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create("projects", function (Blueprint $table) {
            $table->id();
            $table->json("title");
            $table->json("subtitle");
            $table->integer("number_of_staff")->nullable();
            $table->integer("number_of_locations")->nullable();
            $table->year("starting_year")->nullable();
            $table->string("contract_duration")->nullable();
            $table->string('slug')->unique();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists("projects");
    }
};
