<?php

use App\Http\Controllers\Api\ContactMessageController;
use App\Http\Controllers\Api\LocalTalentsController;
use App\Http\Controllers\Api\PartnersController;
use App\Http\Controllers\Api\ProjectsController;
use App\Http\Controllers\Api\SocialsController;
use App\Http\Controllers\Api\ClientsController;
use App\Http\Controllers\Api\NewsController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\PrivacyPolicyPageController;
use App\Http\Controllers\Api\ClientsPageController;
use App\Http\Controllers\Api\PageController;
use App\Http\Controllers\Api\ClientsAlphaPageController;
use App\Http\Controllers\Api\NewsPageController;
use App\Http\Controllers\Api\MajorProjectsPageController;
use App\Http\Controllers\Api\TermsAndConditionsPageController;
use App\Http\Controllers\Api\SolutionsOverviewPageController;
use App\Http\Controllers\Api\ChairmanMessagePageController;
use App\Http\Controllers\Api\MdMessagePageController;
use App\Http\Controllers\Api\AboutUsPageController;
use App\Http\Controllers\Api\OurCulturePageController;

Route::get("/socials", [SocialsController::class, "index"])->name(
    "api.socials.index"
);
Route::post("/contact-messages", [
    ContactMessageController::class,
    "store",
])->name("api.contact-messages.store");
Route::get("/clients", [ClientsController::class, "index"])->name(
    "api.clients.index"
);

Route::get("/partners", [PartnersController::class, "index"])->name(
    "api.partners.index"
);
Route::get("/news", [NewsController::class, "index"])->name("api.news.index");
Route::get("/news/{news:slug}", [NewsController::class, "show"])->name(
    "api.news.show"
);
Route::get("/local-talents", [LocalTalentsController::class, "index"])->name(
    "api.local-talents.index"
);
Route::get("/projects", [ProjectsController::class, "index"])->name(
    "api.projects.index"
);
Route::get("/local-talents/{local_talent:slug}", [
    LocalTalentsController::class,
    "show",
])->name("api.local-talents.show");
Route::get("/projects/{project:slug}", [
    ProjectsController::class,
    "show",
])->name("api.projects.show");

Route::get("/me", [ProfileController::class, "index"])
    ->name("api.profile.index")
    ->middleware("auth:sanctum");
Route::get("/pages/privacy-policy", [
    PrivacyPolicyPageController::class,
    "index",
])->name("api.pages.privacy-policy.index");

Route::get("/pages/clients", [ClientsPageController::class, "index"])->name(
    "api.pages.clients.index"
);

Route::get("/pages/", [PageController::class, "index"])->name(
    "api.pages..index"
);

Route::get("/pages/clients-alpha", [
    ClientsAlphaPageController::class,
    "index",
])->name("api.pages.clients-alpha.index");

Route::get("/pages/news", [NewsPageController::class, "index"])->name(
    "api.pages.news.index"
);

Route::get("/pages/major-projects", [
    MajorProjectsPageController::class,
    "index",
])->name("api.pages.major-projects.index");

Route::get("/pages/terms-and-conditions", [
    TermsAndConditionsPageController::class,
    "index",
])->name("api.pages.terms-and-conditions.index");

Route::get("/pages/solutions-overview", [
    SolutionsOverviewPageController::class,
    "index",
])->name("api.pages.solutions-overview.index");

Route::get("/pages/chairman-message", [
    ChairmanMessagePageController::class,
    "index",
])->name("api.pages.chairman-message.index");

Route::get("/pages/md-message", [
    MdMessagePageController::class,
    "index",
])->name("api.pages.md-message.index");

Route::get("/pages/about-us", [AboutUsPageController::class, "index"])->name(
    "api.pages.about-us.index"
);

Route::get("/pages/our-culture", [
    OurCulturePageController::class,
    "index",
])->name("api.pages.our-culture.index");

Route::get('/pages/privacy-policy', [PrivacyPolicyPageController::class, 'index'])->name('api.pages.privacy-policy.index');
