<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Http\Resources\ClientResource;
use App\Models\Client;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ClientsControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_returns_clients(): void
    {
        $clients = Client::factory()->count(3)->create();
        $resource = ClientResource::collection($clients);

        $this->get(route('api.clients.index', ['lang' => 'en']))
            ->assertOk()
            ->assertJson($resource->response()->getData(true));
    }
}