<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Models\ContactMessage;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ContactMessageControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_can_create_a_contact_message(): void
    {
        $user = User::factory()->create();
        $message = ContactMessage::factory()->make();

        $this->actingAs($user);

        $this->postJson(route('api.contact-messages.store', ['lang' => 'en']), [
            'data' => [
                'type' => 'contact-messages',
                'attributes' => [
                    'name' => $message->name,
                    'email' => $message->email,
                    'message' => $message->message,
                ],
            ],
        ])->assertCreated();
    }

    public function test_guest_users_can_create_a_contact_message(): void
    {
        $message = ContactMessage::factory()->make();

        $this->postJson(route('api.contact-messages.store', ['lang' => 'en']), [
            'data' => [
                'type' => 'contact-messages',
                'attributes' => [
                    'name' => $message->name,
                    'email' => $message->email,
                    'message' => $message->message,
                ],
            ],
        ])->assertCreated();
    }
}
