<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Http\Resources\NewsResource;
use Illuminate\Support\Str;
use App\Models\News;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class NewsControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_returns_news(): void
    {
        $news = News::factory()->count(3)->create();
        $resource = NewsResource::collection($news);

        $this->get(route("api.news.index", ["lang" => "en"]))
            ->assertOk()
            ->assertJson($resource->response()->getData(true));
    }

    public function test_it_fetches_news_by_slug(): void
    {
        $news = \App\Models\News::factory()->create([
            "title" => "Breaking News",
            "slug" => Str::slug("Breaking News"),
        ]);

        $this->get(route("api.news.show", ["slug" => $news->slug]))
            ->assertOk()
            ->assertJson([
                "data" => [
                    "type" => "news",
                    "id" => (string) $news->id,
                    "attributes" => [
                        "title" => $news->title,
                        "body" => $news->body,
                        "image" => $news->getFirstMediaUrl("images"),
                        "createdAt" => $news->created_at->toISOString(),
                        "updatedAt" => $news->updated_at->toISOString(),
                    ],
                ],
            ]);
    }
}
