<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Http\Resources\PartnerResource;
use App\Models\Partner;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class PartnersControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_returns_partners(): void
    {
        $partners = Partner::factory()->count(3)->create();
        $resource = PartnerResource::collection($partners);

        $this->get(route('api.partners.index', ['lang' => 'en']))
            ->assertOk()
            ->assertJson($resource->response()->getData(true));
    }
}