<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Http\Resources\CustomerResource;
use App\Models\Customer;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProfileControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_only_authenticated_customers_can_access_their_profile(): void
    {
        $this->getJson(route('api.profile.index', ['lang' => 'en']))
            ->assertUnauthorized();
    }

    public function test_it_returns_customer_profile(): void
    {
        $customer = Customer::factory()->create();
        $this->actingAs($customer->user);
        $resource = CustomerResource::make($customer);

        $this->getJson(route('api.profile.index', ['lang' => 'en']))
            ->assertOk()
            ->assertJson($resource->response()->getData(true));
    }
}
